<?php $__env->startSection('content'); ?> 
<!-- Header start --> 
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
<!-- Header end --> 
<!-- Inner Page Title start --> 
<div class="pageSearch pt-md-5 pb-md-5">
<form action="<?php echo e(route('job.list')); ?>" method="get">
	<!-- Page Title start -->
	<div class="container">
				<div class="row justify-content-center">
					<div class="col-lg-7">
					<h3 class="mt-0 text-center"><?php echo e(__('Welcome to Your Candidate Dashboard')); ?></h3>
						<div class="searchform">
						<div class="input-group">
							<input type="text"  name="search" id="jbsearch" value="<?php echo e(Request::get('search', '')); ?>" class="form-control" placeholder="<?php echo e(__('Enter Skills or job title')); ?>" autocomplete="off" />
							<button type="submit" class="btn"><i class="fas fa-search"></i></button>
						</div>
						</div>
					</div>
				</div>
	</div>
	<!-- Page Title end -->
</form>
</div>
<!-- Inner Page Title end -->
<div class="listpgWraper">
    <div class="container"><?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row"> <?php echo $__env->make('includes.user_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col-lg-9">
            <?php if(count(auth()->user()->getProfileProjectsArray())==0 || count(auth()->user()->getProfileCvsArray())==0 || count(auth()->user()->profileExperience()->get()) == 0 || count(auth()->user()->profileEducation()->get()) == 0 || count(auth()->user()->profileSkills()->get()) == 0): ?>
				<div class="userprofilealert"><h5><i class="fas fa-exclamation-triangle"></i> Your Resume is incomplete please update.</h5>
				<div class="editbtbn"><a href="<?php echo e(route('build.resume')); ?>"><i class="fas fa-user-edit"></i> Complete CV </a></div>	</div>
				<?php endif; ?>
            <?php echo $__env->make('includes.user_dashboard_stats', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="usercoverphoto"><?php echo e(auth()->user()->printUserCoverImage()); ?>                    
                <a href="<?php echo e(route('my.profile')); ?>"><i class="fas fa-edit"></i></a>
            </div>
             <!-- Profile Information -->
			<div class="profileban">
				<div class="abtuser">
					<div class="row">
						<div class="col-lg-2 col-md-3">
							<div class="uavatar"><?php echo e(auth()->user()->printUserImage()); ?></div>						
						</div>
						<div class="col-lg-10 col-md-9">
							<h4><?php echo e(auth()->user()->name); ?></h4>
							<ul class="userdata">
								<li><i class="fas fa-map-marker-alt" aria-hidden="true"></i> <?php echo e(Auth::user()->getLocation()); ?></li>
								<li><i class="fas fa-phone" aria-hidden="true"></i> <?php echo e(auth()->user()->phone); ?></li>
								<li><i class="fas fa-envelope" aria-hidden="true"></i> <?php echo e(auth()->user()->email); ?></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
            <!-- Applied jobs -->
			<div class="appliedjobswrap">
                <h3><?php echo e(__('My Applied Jobs')); ?></h3>	   	
                <?php if(isset($appliedJobs) && count($appliedJobs)): ?>
                    <table class="table table-striped">
                    <thead class="table-dark">
                            <tr>
                            <th><?php echo e(__('Job Title')); ?></th>
                            <th><?php echo e(__('Company')); ?></th>
                            <th><?php echo e(__('Location')); ?></th>
                            <th><?php echo e(__('Applied Date')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $appliedJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appliedjob): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $job = App\Job::where('id', $appliedjob->job_id)->first();
                                    $company = $job->getCompany();
                                    // Assuming you are using the JobApplication model to store applied jobs
                                    $appliedDate = $appliedjob->created_at->format('Y-m-d'); 
                                ?>
                                <?php if(null !== $company): ?>
                                    <tr>
                                        <td>
                                            <h5><a href="<?php echo e(route('job.detail', [$job->slug])); ?>" title="<?php echo e($job->title); ?>"><?php echo e($job->title); ?></a></h5>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('company.detail', $company->slug)); ?>" title="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></a>
                                        </td>
                                        <td><?php echo e($job->getCity('city')); ?></td>
                                        <td><?php echo e($appliedDate); ?></td> 
                                        <td><?php echo e($appliedjob->status); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('job.detail', [$job->slug])); ?>" class="btn btn-primary"><?php echo e(__('View Details')); ?></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No applied jobs found.</p>
                <?php endif; ?>
			</div>

          


                <?php if((bool)config('jobseeker.is_jobseeker_package_active')): ?>
                <?php
                $packages = App\Package::where('package_for', 'like', 'job_seeker')->get();
                $package = Auth::user()->getPackage();
                if(null !== $package){
                $packages = App\Package::where('package_for', 'like', 'job_seeker')->where('id', '<>', $package->id)->where('package_price', '>=', $package->package_price)->get();
                }
                ?>
                <?php if(null !== $package): ?>
                <?php echo $__env->make('includes.user_package_msg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('includes.user_packages_upgrade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                <?php if(null !== $packages): ?>
                <?php echo $__env->make('includes.user_packages_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?> 



                            <div class="profbox">
                                <h3><?php echo e(__('Recommended Jobs')); ?></h3>
                                <ul class="featuredlist">
                                <?php if(!empty($matchingJobs) && count($matchingJobs) > 0): ?>
    <?php $__currentLoopData = $matchingJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="col-lg-4 col-md-6 <?php if($match->is_featured == 1): ?> featured <?php endif; ?>">
            <div class="jobint">
                <?php if($match->is_featured == 1): ?> 
                    <span class="promotepof-badge"><i class="fa fa-bolt" title="<?php echo e(__('This Match is Featured')); ?>"></i></span> 
                <?php endif; ?>
                <div class="d-flex">
                    <div class="fticon"><i class="fas fa-briefcase"></i> <?php echo e($match->getJobType('job_type')); ?></div>                        
                </div>
                <h4>
                    <a href="<?php echo e(route('job.detail', [$match->slug])); ?>" title="<?php echo e($match->title); ?>">
                        <?php echo \Illuminate\Support\Str::limit($match->title, 20, '...'); ?>

                    </a>
                </h4>                                        
                <?php if(!(bool)$match->hide_salary): ?>                    
                    <div class="salary mb-2">Salary: 
                        <strong><?php echo e($match->salary_currency.''.$match->salary_from); ?> - <?php echo e($match->salary_currency.''.$match->salary_to); ?>/<?php echo e($match->getSalaryPeriod('salary_period')); ?></strong>
                    </div>
                <?php endif; ?> 
                <strong><i class="fas fa-map-marker-alt"></i> <?php echo e($match->getCity('city')); ?></strong>                                         
                <div class="jobcompany">
                    <div class="ftjobcomp">
                        <span><?php echo e($match->created_at->format('M d, Y')); ?></span>
                        <?php if(isset($match->company)): ?>
                            <a href="<?php echo e(route('company.detail', $match->company->slug)); ?>" title="<?php echo e($match->company->name); ?>"><?php echo e($match->company->name); ?></a>
                        <?php endif; ?>
                    </div>
                    <?php if(isset($match->company)): ?>
                        <a href="<?php echo e(route('company.detail', $match->company->slug)); ?>" class="company-logo" title="<?php echo e($match->company->name); ?>"><?php echo e($match->company->printCompanyImage()); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
<?php else: ?>
    <div class="alert alert-danger"><?php echo e(__('No matching jobs found')); ?></div>
<?php endif; ?>

                                </ul>
                            </div>

 <!-- My Followings -->

                            <div class="profbox followbox">
								<h3><?php echo e(__('My Followings')); ?> <a href="<?php echo e(route('my.followings')); ?>"><?php echo e(__('View All')); ?> <i class="fas fa-arrow-right"></i></a></h3>
								<ul class="row compnaieslist">
								<?php if(isset($followers) && $followers->isNotEmpty()): ?>
                                <?php $__currentLoopData = $followers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $follow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $company = \App\Company::where('slug', $follow->company_slug)
                                        ->where('is_active', 1)
                                        ->first();
                                ?>
                                <?php if(isset($company)): ?>
                                    <li class="col-lg-4 col-md-6">
                                        <div class="empint">
                                            <a href="<?php echo e(route('company.detail', $company->slug)); ?>" title="<?php echo e($company->name); ?>">
                                                <div class="emptbox">
                                                    <div class="comimg"><?php echo e($company->printCompanyImage()); ?></div>
                                                    <div class="text-info-right">
                                                        <h4><?php echo e($company->name); ?></h4>    
                                                        <?php if($company->getIndustry('industry')): ?>
                                                            <div class="indst">                            
                                                                <?php echo e($company->getIndustry('industry')); ?>                          
                                                            </div>
                                                        <?php endif; ?>
                                                        <div class="emloc"><i class="fas fa-map-marker-alt"></i> <?php echo e($company->location); ?></div>
                                                    </div>                                         
                                                    <div class="cm-info-bottom">
                                                        <span><i class="fas fa-briefcase"></i> <?php echo e($company->countNumJobs('company_id',$company->id)); ?> <?php echo e(__('Open Jobs')); ?></span>
                                                    </div>    
                                                </div>
                                            </a>                    
                                        </div>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <li class="col-lg-12"><?php echo e(__('No Followings Found')); ?></li>
                                <?php endif; ?>
								</ul>
								
							</div>


			</div>
        </div>
    </div>
</div>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<?php echo $__env->make('includes.immediate_available_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
$(document).ready(function() {
    function fadeTextEffect(texts) {
        var index = 0;
        function fadeText() {
            $(texts[index])
                .fadeIn(500) // Fade in over 1 second
                .delay(8000) // Display for 8 seconds
                .fadeOut(500, function() { // Fade out over 1 second
                    index = (index + 1) % texts.length; // Move to the next text
                    fadeText(); // Recursively call to continue the loop
                });
        }
        fadeText(); // Start the animation loop
    }
    // Apply the fade effect to both fade-text and fadetext2
    fadeTextEffect($('.fade-text'));
    fadeTextEffect($('.fadetext2'));
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jobsportal\resources\views/home.blade.php ENDPATH**/ ?>